<?php

namespace App\Controller;

use App\Entity\AgendaMedica;
use App\Form\AgendaMedicaType;
use App\Form\EditarAgendaMedicaType;
use App\Repository\AgendaMedicaRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/agenda/medica', name: 'app_admin_agenda_medica_')]
class AgendaMedicaController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(Request $request, EntityManagerInterface $em, AgendaMedicaRepository $agendaMedicaRepository, PaginatorInterface $paginator): Response
    {

        $agenda = new AgendaMedica();
        $form = $this->createForm(AgendaMedicaType::class,$agenda);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $data = $agenda->getDataDeservico();
            $agenda->setDisponivel("".$data->format('d-m-y')."/".$agenda->getUsers()->getNome());
            $em->persist($agenda);
            $em->flush();
            //$this->addFlash('success','Calendario agendado com sucesso!');
            return $this->redirectToRoute('app_admin_agenda_medica_index');
        }
        $query = $agendaMedicaRepository->findAllAgendaMedica();
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),4 );
        return $this->render('agenda_medica/index.html.twig', [
            'form' => $form->createView(),
            'pagination' => $pagination
        ]);
    }

    #[Route('/editar/{id}', name: 'edit')]
    public function editAgendaMedica(AgendaMedica $agendaMedica, Request $request, EntityManagerInterface $em): Response
    {
        $form = $this->createForm(EditarAgendaMedicaType::class,$agendaMedica);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($agendaMedica);
            $em->flush();
            //$this->addFlash('success','Agenda médica alterada com sucesso!');
            return $this->redirectToRoute('app_admin_agenda_medica_index');
        }
        return $this->render('agenda_medica/editAgendamedica.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    #[Route('/apagar/{id}', name: 'delete')]
    public function deleteProvincia(AgendaMedica $agendaMedica, EntityManagerInterface $em){
        $em->remove($agendaMedica);
        $em->flush();
        //$this->addFlash('success','Paciênte removido com sucesso!');
        return $this->redirectToRoute('app_admin_agenda_medica_index');
    }
}
