<?php

namespace App\Controller;

use App\Entity\AssegurarPaciente;
use App\Form\AssegurarPacienteType;
use App\Repository\AssegurarPacienteRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/assegurar/paciente', name: 'app_admin_assegurar_paciente_')]
class AssegurarPacienteController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(Request $request, EntityManagerInterface $em, AssegurarPacienteRepository $assegurarPacienteRepository, PaginatorInterface $paginator): Response
    {
        $assegurar = new AssegurarPaciente();
        $form = $this->createForm(AssegurarPacienteType::class,$assegurar);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($assegurar);
            $em->flush();
            //$this->addFlash('success','Calendario agendado com sucesso!');
            return $this->redirectToRoute('app_admin_assegurar_paciente_index');
        }
        $query = $assegurarPacienteRepository->findAll();
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),4 );
        return $this->render('assegurar_paciente/index.html.twig', [
            'form' => $form->createView(),
            'pagination' => $pagination
        ]);

    }

    #[Route('/editar/{id}', name: 'edit')]
    public function editSeguro(AssegurarPaciente $assegurarPaciente, Request $request, EntityManagerInterface $em, AssegurarPacienteRepository $assegurarPacienteRepository, PaginatorInterface $paginator): Response
    {
        $form = $this->createForm(AssegurarPacienteType::class,$assegurarPaciente);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($assegurarPaciente);
            $em->flush();
            //$this->addFlash('success','Calendario agendado com sucesso!');
            return $this->redirectToRoute('app_admin_assegurar_paciente_index');
        }
        $query = $assegurarPacienteRepository->findAll();
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),4 );
        return $this->render('assegurar_paciente/editAssegurarPaciente.html.twig', [
            'form' => $form->createView(),
            'pagination' => $pagination
        ]);

    }

    #[Route('/desativar/{id}', name: 'desativar')]
    public function desativarSeguro(AssegurarPaciente $assegurarPaciente, EntityManagerInterface $em, PaginatorInterface $paginator): Response
    {
        $assegurarPaciente->setIsAtivo(false);
        $em->persist($assegurarPaciente);
        $em->flush();
        //$this->addFlash('success','Calendario agendado com sucesso!');
        return $this->redirectToRoute('app_admin_assegurar_paciente_index');
    }
}
