<?php

namespace App\Controller;

use App\Entity\Bairro;
use App\Form\BairroType;
use App\Repository\BairroRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/bairro', name: 'app_bairro_')]
class BairroController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(BairroRepository $bairroRepository): Response
    {
        $bairros = $bairroRepository->findBairros();
        return $this->render('bairro/index.html.twig', compact('bairros'));
    }

    #[Route('/add', name: 'add')]
    public function addBairro(Request $request, EntityManagerInterface $em): Response
    {
        $bairro = new Bairro();
        $form = $this->createForm(BairroType::class,$bairro);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($bairro);
            $em->flush();
            $this->addFlash('success','Bairro salvo com sucesso!');
            return $this->redirectToRoute('app_bairro_add');
        }
        return $this->render('bairro/addBairro.html.twig', [
            'form' => $form->createView(),
        ]);
    }
}
