<?php

namespace App\Controller;

use App\Entity\CalendarioMed;
use App\Form\CalendarioMedType;
use App\Repository\CalendarioMedRepository;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/calendario/med')]
class CalendarioMedController extends AbstractController
{
    #[Route('/', name: 'app_calendario_med_index', methods: ['GET'])]
    public function index(CalendarioMedRepository $calendarioMedRepository): Response
    {
        return $this->render('calendario_med/index.html.twig', [
            'calendario_meds' => $calendarioMedRepository->findAll(),
        ]);
    }

    #[Route('/new', name: 'app_calendario_med_new', methods: ['GET', 'POST'])]
    public function new(Request $request, CalendarioMedRepository $calendarioMedRepository): Response
    {
        $calendarioMed = new CalendarioMed();
        $form = $this->createForm(CalendarioMedType::class, $calendarioMed);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $calendarioMed->setTitle($calendarioMed->getTitle() ."/".$calendarioMed->getMedico()->getNome());
            $calendarioMed->setDisponivel("".$calendarioMed->getStart()->format('d-m-y')."/".$calendarioMed->getMedico()->getNome());
            $calendarioMedRepository->save($calendarioMed, true);

            return $this->redirectToRoute('app_calendario_med_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('calendario_med/new.html.twig', [
            'calendario_med' => $calendarioMed,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_calendario_med_show', methods: ['GET'])]
    public function show(CalendarioMed $calendarioMed): Response
    {
        return $this->render('calendario_med/show.html.twig', [
            'calendario_med' => $calendarioMed,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_calendario_med_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, CalendarioMed $calendarioMed, CalendarioMedRepository $calendarioMedRepository): Response
    {
        $form = $this->createForm(CalendarioMedType::class, $calendarioMed);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $calendarioMedRepository->save($calendarioMed, true);

            return $this->redirectToRoute('app_calendario_med_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->renderForm('calendario_med/edit.html.twig', [
            'calendario_med' => $calendarioMed,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_calendario_med_delete', methods: ['POST'])]
    public function delete(Request $request, CalendarioMed $calendarioMed, CalendarioMedRepository $calendarioMedRepository): Response
    {
        if ($this->isCsrfTokenValid('delete'.$calendarioMed->getId(), $request->request->get('_token'))) {
            $calendarioMedRepository->remove($calendarioMed, true);
        }

        return $this->redirectToRoute('app_calendario_med_index', [], Response::HTTP_SEE_OTHER);
    }
}
