<?php

namespace App\Controller;

use App\Entity\Empresa;
use App\Form\EmpresaType;
use App\Repository\EmpresaRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/empresa', name: 'app_admin_empresa_')]
class EmpresaController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(EmpresaRepository $empresaRepository): Response
    {
        $empresa = $empresaRepository->findEmpresa();
        return $this->render('empresa/index.html.twig', compact('empresa'));
    }

    #[Route('/add', name: 'add')]
    public function addEmpresa(Request $request, EntityManagerInterface $em): Response
    {
        $empresa = new Empresa();
        $form = $this->createForm(EmpresaType::class,$empresa);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($empresa);
            $em->flush();
            $this->addFlash('success','Dados da empresa configurado com sucesso!');
            return $this->redirectToRoute('app_admin_empresa_add');
        }
        return $this->render('empresa/addEmpresa.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    #[Route('/edit/{id}', name: 'edit')]
    public function editEmpresa(Empresa $empresa,Request $request, EntityManagerInterface $em): Response
    {
        $form = $this->createForm(EmpresaType::class,$empresa);
        $form->handleRequest($request);
        if($form->isSubmitted() && $form->isValid()){
            $em->persist($empresa);
            $em->flush();
            $this->addFlash('success','Dados da empresa alterado com sucesso!');
            return $this->redirectToRoute('app_admin_empresa_index');
        }
        return $this->render('empresa/editEmpresa.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    /*
    #[Route('/apagar/{id}', name: 'delete')]
    public function deleteMunicipio(Municipio $municipio, EntityManagerInterface $em){

        $em->remove($municipio);
        $em->flush();
        $this->addFlash('success','Município removido com sucesso!');
        return $this->redirectToRoute('app_admin_empresa_index');
    }*/
}
