<?php

namespace App\Controller;

use App\Entity\Paciente;
use App\Form\PacienteType;
use App\Repository\PacienteRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/paciente', name: 'app_admin_paciente_')]
class PacienteController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(PacienteRepository $pacienteRepository, PaginatorInterface $paginator,Request $request, EntityManagerInterface $em): Response
    {
        $paciente = new Paciente();
        $form = $this->createForm(PacienteType::class,$paciente);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($paciente);
            $em->flush();
            //$this->addFlash('success','Dados do paciênte salvo com sucesso!');
            return $this->redirectToRoute('app_admin_paciente_index');
        }

        $query = $pacienteRepository->findPacientes();
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),6 );

        return $this->render('paciente/index.html.twig', [
            'form' => $form->createView(),
            'pagination' => $pagination
        ]);
    }

    #[Route('/editar/{id}', name: 'edit')]
    public function editPaciente(Paciente $paciente, Request $request, EntityManagerInterface $em): Response
    {
        $form = $this->createForm(PacienteType::class,$paciente);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($paciente);
            $em->flush();
            $this->addFlash('success','Dados do paciênte editado com sucesso!');
            return $this->redirectToRoute('app_admin_paciente_index');
        }
        return $this->render('paciente/editPaciente.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    #[Route('/apagar/{id}', name: 'delete')]
    public function deleteProvincia(Paciente $paciente, EntityManagerInterface $em){

        $em->remove($paciente);
        $em->flush();
        $this->addFlash('success','Paciênte removido com sucesso!');
        return $this->redirectToRoute('app_admin_paciente_index');
    }
}
