<?php

namespace App\Controller;

use App\Entity\Seguradora;
use App\Form\SeguradoraType;
use App\Repository\SeguradoraRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/seguradora', name: 'app_admin_seguradora_')]
class SeguradoraController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(Request $request, EntityManagerInterface $em,
                          SeguradoraRepository $seguradoraRepository, PaginatorInterface $paginator): Response
    {
        $seguradora = new Seguradora();
        $form = $this->createForm(SeguradoraType::class,$seguradora);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($seguradora);
            $em->flush();
            $this->addFlash('success','Seguradora salva com sucesso!');
            return $this->redirectToRoute('app_admin_seguradora_index');
        }
        $query = $seguradoraRepository->findAll();
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),6 );
        return $this->render('seguradora/index.html.twig', [
            'form' => $form->createView(),
            'pagination' => $pagination
        ]);
    }

    #[Route('/edit/{id}', name: 'edit')]
    public function editSeguradora(Seguradora $seguradora,Request $request, EntityManagerInterface $em): Response
    {
        $form = $this->createForm(SeguradoraType::class,$seguradora);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($seguradora);
            $em->flush();
            //$this->addFlash('success','Seguradora salva com sucesso!');
            return $this->redirectToRoute('app_admin_seguradora_index');
        }
        return $this->render('seguradora/editSeguradora.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    #[Route('/apagar/{id}', name: 'delete')]
    public function deleteServico(Servico $servico, EntityManagerInterface $em){
        $em->remove($servico);
        $em->flush();
        $this->addFlash('success','Serviço removido com sucesso!');
        return $this->redirectToRoute('app_admin_servico_index');
    }

}
