<?php

namespace App\Controller;

use App\Entity\TipoDeSeguradora;
use App\Form\TipoDeSeguroType;
use App\Repository\TipoDeSeguradoraRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/tipo/segurada', name: 'app_admin_tipo_segurada_')]
class TipoSeguradaController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(Request $request, EntityManagerInterface $em,
                          TipoDeSeguradoraRepository $tipoDeSeguradoraRepository, PaginatorInterface $paginator): Response
    {
        $tipo = new TipoDeSeguradora();
        $form = $this->createForm(TipoDeSeguroType::class,$tipo);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($tipo);
            $em->flush();
            $this->addFlash('success','Tipo de seguradora salva com sucesso!');
            return $this->redirectToRoute('app_admin_tipo_segurada_index');
        }
        $query = $tipoDeSeguradoraRepository->findAll();
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),4 );
        return $this->render('tipo_segurada/index.html.twig', [
            'form' => $form->createView(),
            'pagination' => $pagination
        ]);

    }

    #[Route('/edit/{id}', name: 'edit')]
    public function editTipoSeguro(TipoDeSeguradora $tipoDeSeguradora,Request $request, EntityManagerInterface $em): Response
    {
        $form = $this->createForm(TipoDeSeguroType::class,$tipoDeSeguradora);
        $form->handleRequest($request);
        if($form->isSubmitted() && $form->isValid()){
            $em->persist($tipoDeSeguradora);
            $em->flush();
            //$this->addFlash('success','Seguradora salva com sucesso!');
            return $this->redirectToRoute('app_admin_tipo_segurada_index');
        }
        return $this->render('tipo_segurada/editTipoSeguro.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    #[Route('/apagar/{id}', name: 'delete')]
    public function deleteTipoSeguro(TipoDeSeguradora $tipoDeSeguradora, EntityManagerInterface $em){
        $em->remove($tipoDeSeguradora);
        $em->flush();
        //$this->addFlash('success','Paciênte removido com sucesso!');
        return $this->redirectToRoute('app_admin_tipo_segurada_index');
    }
}
