<?php

namespace App\Controller;

use App\Entity\Triagem;
use App\Form\TriagemType;
use App\Repository\TriagemRepository;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;

#[Route('/admin/triagem', name: 'app_admin_triagem_')]
class TriagemController extends AbstractController
{
    #[Route('/', name: 'index')]
    public function index(TriagemRepository $triagemRepository, PaginatorInterface $paginator, Request $request, EntityManagerInterface $em): Response
    {
        $triagem = new Triagem();
        $form = $this->createForm(TriagemType::class,$triagem);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $ramdom = random_int(1,5000);
            $triagem->setCodigoTriagem("T-".$ramdom );
            $em->persist($triagem);
            $em->flush();
            //$this->addFlash('success','Triagem feita com sucesso!');
            return $this->redirectToRoute('app_admin_triagem_index');
        }
        $query = $triagemRepository->findTriagens();
        $pagination = $paginator->paginate($query,$request->query->getInt('page',1),2 );
        return $this->render('triagem/index.html.twig', [
            'form' => $form->createView(),
            'pagination' => $pagination
        ]);
    }

    #[Route('/editar/{id}', name: 'edit')]
    public function addTriagem(Triagem $triagem, Request $request, EntityManagerInterface $em): Response
    {
        $form = $this->createForm(TriagemType::class,$triagem);
        $form->handleRequest($request);

        if($form->isSubmitted() && $form->isValid()){
            $em->persist($triagem);
            $em->flush();
            //$this->addFlash('success','Triagem feita com sucesso!');
            return $this->redirectToRoute('app_admin_triagem_index');
        }
        return $this->render('triagem/editTriagem.html.twig', [
            'form' => $form->createView(),
        ]);
    }

    #[Route('/apagar/{id}', name: 'delete')]
    public function deleteTriagem(Triagem $triagem, EntityManagerInterface $em){

        $triagem->setIsAtivo(false);
        $em->persist($triagem);
        $em->flush();
        //$this->addFlash('success','Triagem removida com sucesso!');
        return $this->redirectToRoute('app_admin_triagem_index');
    }
}
