<?php

namespace App\Entity;

use App\Repository\CalendarioMedRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: CalendarioMedRepository::class)]
class CalendarioMed
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 100)]
    private ?string $title = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $start = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $end = null;

    #[ORM\Column(type: Types::TEXT)]
    private ?string $description = null;

    #[ORM\Column]
    private ?bool $allDay = null;

    #[ORM\Column(length: 7)]
    private ?string $backgroundColor = null;

    #[ORM\Column(length: 7)]
    private ?string $borderColor = null;

    #[ORM\Column(length: 7)]
    private ?string $textColor = null;

    #[ORM\ManyToOne(inversedBy: 'calendarioMeds')]
    private ?Usuario $medico = null;

    #[ORM\OneToMany(mappedBy: 'calendarioMedico', targetEntity: MarcacaoConsulta::class)]
    private Collection $marcacaoConsultas;

    #[ORM\Column(length: 100, nullable: true)]
    private ?string $disponivel = null;



    public function __construct()
    {
        $this->marcacaoConsultas = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getStart(): ?\DateTimeInterface
    {
        return $this->start;
    }

    public function setStart(\DateTimeInterface $start): self
    {
        $this->start = $start;

        return $this;
    }

    public function getEnd(): ?\DateTimeInterface
    {
        return $this->end;
    }

    public function setEnd(\DateTimeInterface $end): self
    {
        $this->end = $end;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function isAllDay(): ?bool
    {
        return $this->allDay;
    }

    public function setAllDay(bool $allDay): self
    {
        $this->allDay = $allDay;

        return $this;
    }

    public function getBackgroundColor(): ?string
    {
        return $this->backgroundColor;
    }

    public function setBackgroundColor(string $backgroundColor): self
    {
        $this->backgroundColor = $backgroundColor;

        return $this;
    }

    public function getBorderColor(): ?string
    {
        return $this->borderColor;
    }

    public function setBorderColor(string $borderColor): self
    {
        $this->borderColor = $borderColor;

        return $this;
    }

    public function getTextColor(): ?string
    {
        return $this->textColor;
    }

    public function setTextColor(string $textColor): self
    {
        $this->textColor = $textColor;

        return $this;
    }

    public function getMedico(): ?Usuario
    {
        return $this->medico;
    }

    public function setMedico(?Usuario $medico): self
    {
        $this->medico = $medico;

        return $this;
    }

    /**
     * @return Collection<int, MarcacaoConsulta>
     */
    public function getMarcacaoConsultas(): Collection
    {
        return $this->marcacaoConsultas;
    }

    public function addMarcacaoConsulta(MarcacaoConsulta $marcacaoConsulta): self
    {
        if (!$this->marcacaoConsultas->contains($marcacaoConsulta)) {
            $this->marcacaoConsultas->add($marcacaoConsulta);
            $marcacaoConsulta->setCalendarioMedico($this);
        }

        return $this;
    }

    public function removeMarcacaoConsulta(MarcacaoConsulta $marcacaoConsulta): self
    {
        if ($this->marcacaoConsultas->removeElement($marcacaoConsulta)) {
            // set the owning side to null (unless already changed)
            if ($marcacaoConsulta->getCalendarioMedico() === $this) {
                $marcacaoConsulta->setCalendarioMedico(null);
            }
        }

        return $this;
    }

    public function getDisponivel(): ?string
    {
        return $this->disponivel;
    }

    public function setDisponivel(?string $disponivel): self
    {
        $this->disponivel = $disponivel;

        return $this;
    }

}
