<?php

namespace App\Entity;

use App\Repository\MarcacaoConsultaRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: MarcacaoConsultaRepository::class)]
class MarcacaoConsulta
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $createdAt = null;

    #[ORM\Column(nullable: true)]
    private ?\DateTimeImmutable $updatedAt = null;

    #[ORM\Column(nullable: true)]
    private ?bool $isAtivo = null;

    #[ORM\ManyToOne(inversedBy: 'marcacaoConsultas')]
    private ?Triagem $codTriagem = null;

    #[ORM\ManyToOne(inversedBy: 'marcacaoConsultas')]
    private ?CalendarioMed $calendarioMedico = null;



    public  function __construct()
    {
        $this->createdAt = new \DateTimeImmutable();
        $this->updatedAt = new \DateTimeImmutable();
        $this->isAtivo = true;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->createdAt;
    }

    public function setCreatedAt(?\DateTimeImmutable $createdAt): self
    {
        $this->createdAt = $createdAt;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeImmutable
    {
        return $this->updatedAt;
    }

    public function setUpdatedAt(?\DateTimeImmutable $updatedAt): self
    {
        $this->updatedAt = $updatedAt;

        return $this;
    }

    public function isIsAtivo(): ?bool
    {
        return $this->isAtivo;
    }

    public function setIsAtivo(?bool $isAtivo): self
    {
        $this->isAtivo = $isAtivo;

        return $this;
    }

    public function getCodTriagem(): ?Triagem
    {
        return $this->codTriagem;
    }

    public function setCodTriagem(?Triagem $codTriagem): self
    {
        $this->codTriagem = $codTriagem;

        return $this;
    }

    public function getCalendarioMedico(): ?CalendarioMed
    {
        return $this->calendarioMedico;
    }

    public function setCalendarioMedico(?CalendarioMed $calendarioMedico): self
    {
        $this->calendarioMedico = $calendarioMedico;

        return $this;
    }

}
