<?php

namespace App\Entity;

use App\Repository\UsuarioRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Security\Core\User\PasswordAuthenticatedUserInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: UsuarioRepository::class)]
#[UniqueEntity(fields: ['email'], message: 'Já existe uma conta com esse e-mail')]
#[UniqueEntity(fields: ['email'], message: 'Já existe uma conta com esse e-mail')]
class Usuario implements UserInterface, PasswordAuthenticatedUserInterface
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 180, unique: true)]
    private ?string $email = null;

    #[ORM\Column]
    private array $roles = [];

    /**
     * @var string The hashed password
     */
    #[ORM\Column]
    private ?string $password = null;

    #[ORM\Column(type: 'boolean')]
    private $isVerified = false;

    #[ORM\Column(length: 60, nullable: true)]
    private ?string $nome = null;

    #[ORM\Column(nullable: true)]
    private ?bool $isAtivo = null;

    #[ORM\ManyToOne(inversedBy: 'users')]
    private ?AreaFormacao $formacao = null;

    #[ORM\ManyToOne(inversedBy: 'users')]
    private ?Empresa $instituicao = null;

    #[ORM\Column(nullable: true)]
    private ?int $numOrdem = null;

    #[ORM\ManyToOne(inversedBy: 'usuarios')]
    private ?Bairro $bairro = null;

    #[ORM\Column(nullable: true)]
    private ?int $telefone = null;

    #[ORM\OneToMany(mappedBy: 'medico', targetEntity: CalendarioMed::class)]
    private Collection $calendarioMeds;


    public function __construct()
    {
        $this->isAtivo = false;
        $this->calendarioMeds = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    /**
     * A visual identifier that represents this user.
     *
     * @see UserInterface
     */
    public function getUserIdentifier(): string
    {
        return (string) $this->email;
    }

    /**
     * @see UserInterface
     */
    public function getRoles(): array
    {
        $roles = $this->roles;
        // guarantee every user at least has ROLE_USER
        $roles[] = 'ROLE_USER';

        return array_unique($roles);
    }

    public function setRoles(array $roles): self
    {
        $this->roles = $roles;

        return $this;
    }

    /**
     * @see PasswordAuthenticatedUserInterface
     */
    public function getPassword(): string
    {
        return $this->password;
    }

    public function setPassword(string $password): self
    {
        $this->password = $password;

        return $this;
    }

    /**
     * @see UserInterface
     */
    public function eraseCredentials()
    {
        // If you store any temporary, sensitive data on the user, clear it here
        // $this->plainPassword = null;
    }

    public function isVerified(): bool
    {
        return $this->isVerified;
    }

    public function setIsVerified(bool $isVerified): self
    {
        $this->isVerified = $isVerified;

        return $this;
    }

    public function getNome(): ?string
    {
        return $this->nome;
    }

    public function setNome(?string $nome): self
    {
        $this->nome = $nome;

        return $this;
    }

    public function isIsAtivo(): ?bool
    {
        return $this->isAtivo;
    }

    public function setIsAtivo(?bool $isAtivo): self
    {
        $this->isAtivo = $isAtivo;

        return $this;
    }

    public function getFormacao(): ?AreaFormacao
    {
        return $this->formacao;
    }

    public function setFormacao(?AreaFormacao $formacao): self
    {
        $this->formacao = $formacao;

        return $this;
    }

    public function getInstituicao(): ?Empresa
    {
        return $this->instituicao;
    }

    public function setInstituicao(?Empresa $instituicao): self
    {
        $this->instituicao = $instituicao;

        return $this;
    }

    public function getNumOrdem(): ?int
    {
        return $this->numOrdem;
    }

    public function setNumOrdem(?int $numOrdem): self
    {
        $this->numOrdem = $numOrdem;

        return $this;
    }

    public function getBairro(): ?Bairro
    {
        return $this->bairro;
    }

    public function setBairro(?Bairro $bairro): self
    {
        $this->bairro = $bairro;

        return $this;
    }

    public function getTelefone(): ?int
    {
        return $this->telefone;
    }

    public function setTelefone(?int $telefone): self
    {
        $this->telefone = $telefone;

        return $this;
    }

    /**
     * @return Collection<int, CalendarioMed>
     */
    public function getCalendarioMeds(): Collection
    {
        return $this->calendarioMeds;
    }

    public function addCalendarioMed(CalendarioMed $calendarioMed): self
    {
        if (!$this->calendarioMeds->contains($calendarioMed)) {
            $this->calendarioMeds->add($calendarioMed);
            $calendarioMed->setMedico($this);
        }

        return $this;
    }

    public function removeCalendarioMed(CalendarioMed $calendarioMed): self
    {
        if ($this->calendarioMeds->removeElement($calendarioMed)) {
            // set the owning side to null (unless already changed)
            if ($calendarioMed->getMedico() === $this) {
                $calendarioMed->setMedico(null);
            }
        }

        return $this;
    }


}
