<?php

namespace App\Form;

use App\Entity\CalendarioMed;
use App\Entity\Usuario;
use App\Repository\UsuarioRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ColorType;
use Symfony\Component\Form\Extension\Core\Type\DateTimeType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CalendarioMedType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('title')
            ->add('start', DateTimeType::class,[
                'date_widget' =>'single_text'
            ])
            ->add('end',DateTimeType::class,[
                'date_widget' =>'single_text'
            ])
            ->add('description')
            ->add('allDay')
            ->add('backgroundColor', ColorType::class)
            ->add('borderColor', ColorType::class)
            ->add('textColor',ColorType::class)
            ->add('medico',EntityType::class,[
                'class'=> Usuario::class,
                'choice_label' => 'nome',
                'label' => 'Usuário',
                'query_builder' => function(UsuarioRepository $usuarioRepository){
                    return $usuarioRepository->createQueryBuilder('m')
                        ->andWhere('m.roles = :val')
                        ->setParameter('val', '["ROLE_MEDICO_ADMIN"]')
                        ->orderBy('m.nome','ASC');
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => CalendarioMed::class,
        ]);
    }
}
