<?php

namespace App\Form;

use App\Entity\Comuna;
use App\Entity\Municipio;
use App\Repository\MunicipioRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class ComunaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nome')
            ->add('municipio',EntityType::class,[
                'class'=> Municipio::class,
                'choice_label' => 'nome',
                'label' => 'Município',
                'query_builder' => function(MunicipioRepository $municipioRepository){
                    return $municipioRepository->createQueryBuilder('p')
                        ->orderBy('p.nome','ASC');
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Comuna::class,
        ]);
    }
}
