<?php

namespace App\Form;

use App\Entity\AgendaMedica;
use App\Entity\Usuario;
use App\Repository\UsuarioRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class EditarAgendaMedicaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('dataDeservico')
            ->add('isAtivo')
            ->add('users',EntityType::class,[
                'class'=> Usuario::class,
                'choice_label' => 'nome',
                'label' => 'Médico',
                'query_builder' => function(UsuarioRepository $usuarioRepository){
                    return $usuarioRepository->createQueryBuilder('m')
                        ->andWhere('m.roles = :val')
                        ->setParameter('val', '["ROLE_MEDICO_ADMIN"]')
                        ->orderBy('m.nome','ASC');
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => AgendaMedica::class,
        ]);
    }
}
