<?php

namespace App\Form;

use App\Entity\AgendaMedica;
use App\Entity\CalendarioMed;
use App\Entity\MarcacaoConsulta;
use App\Entity\Paciente;
use App\Entity\Triagem;
use App\Entity\Usuario;
use App\Repository\AgendaMedicaRepository;
use App\Repository\CalendarioMedRepository;
use App\Repository\PacienteRepository;
use App\Repository\TriagemRepository;
use App\Repository\UsuarioRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class MarcacaoConsultaType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            //->add('dataDaconsultaAt')
            ->add('codTriagem',EntityType::class,[
                'class'=> Triagem::class,
                'choice_label' => 'codigoTriagem',
                'label' => 'Codigo da triagem',
                'query_builder' => function(TriagemRepository $triagemRepository){
                    return $triagemRepository->createQueryBuilder('p')
                        ->orderBy('p.codigoTriagem','ASC');
                }
            ])
            ->add('calendarioMedico',EntityType::class,[
                'class'=> CalendarioMed::class,
                'choice_label' => 'disponivel',
                'label' => 'Data disponivel',
                'query_builder' => function(CalendarioMedRepository $calendarioMedRepository){
                    return $calendarioMedRepository->createQueryBuilder('m')
                        ->orderBy('m.disponivel','ASC');
                        //->andWhere('m.roles = :val')
                        //->setParameter('val', '["ROLE_MEDICO_ADMIN"]')
                        //->orderBy('m.nome','ASC');
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => MarcacaoConsulta::class,
        ]);
    }
}
