<?php

namespace App\Form;

use App\Entity\Bairro;
use App\Entity\Paciente;
use App\Repository\BairroRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PacienteType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nome')
            ->add('genero',ChoiceType::class,[
                'choices'=> array(
                    'Masculino' => 'Masculino',
                    'Femenino' => 'Femenino'
                )
            ])
            ->add('tipoSanguineo',ChoiceType::class,[
                'choices'=> array(
                    'Tipo A+' => 'A+',
                    'Tipo A-' => 'A-',
                    'Tipo B+' => 'B+',
                    'Tipo B-' => 'B-',
                    'Tipo AB+' => 'AB+',
                    'Tipo AB-' => 'AB-',
                    'Tipo O+' => 'O+',
                    'Tipo O-' => 'O-'
                )
            ])
            ->add('doencafamiliar')
            ->add('grupoSanguineo',ChoiceType::class,[
                'choices'=> array(
                    'Grupo A' => 'Grupo A',
                    'Grupo B' => 'Grupo B',
                    'Grupo AB' => 'Grupo AB',
                    'Grupo O' => 'Grupo O'
                )
            ])
            ->add('outrosproblemasDeSaude')
            ->add('contacto')
            ->add('bairro',EntityType::class,[
                'class'=> Bairro::class,
                'choice_label' => 'nome',
                'label' => 'Bairro',
                'query_builder' => function(BairroRepository $bairroRepository){
                     return $bairroRepository->createQueryBuilder('p')->orderBy('p.nome','ASC');
                }
            ])
        ;
        /*$builder->get('genero')
        ->addModelTransformer(new CallbackTransformer(
            function ($genero) {
                // transform the array to a string
                return count($genero)? $genero[0]: null;
            },
            function ($rolesString) {
                // transform the string back to an array
                return [$rolesString];
            }
        ));
        $builder->get('tipoSanguineo')
            ->addModelTransformer(new CallbackTransformer(
                function ($rolesArray) {
                    // transform the array to a string
                    return count($rolesArray)? $rolesArray[0]: null;
                },
                function ($rolesString) {
                    // transform the string back to an array
                    return [$rolesString];
                }
            ));
        $builder->get('grupoSanguineo')
            ->addModelTransformer(new CallbackTransformer(
                function ($rolesArray) {
                    // transform the array to a string
                    return count($rolesArray)? $rolesArray[0]: null;
                },
                function ($rolesString) {
                    // transform the string back to an array
                    return [$rolesString];
                }
            ));*/
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Paciente::class,
        ]);
    }
}
