<?php

namespace App\Form;

use App\Entity\Seguradora;
use App\Entity\TipoDeSeguradora;
use App\Repository\SeguradoraRepository;
use App\Repository\TipoDeSeguradoraRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TipoDeSeguroType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('nomeTipo')
            ->add('seguradora',EntityType::class,[
                'class'=> Seguradora::class,
                'choice_label' => 'nome',
                'label' => 'Seguradora',
                'query_builder' => function(SeguradoraRepository $seguradoraRepository){
                    return $seguradoraRepository->createQueryBuilder('s')
                        ->orderBy('s.nome','ASC');
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => TipoDeSeguradora::class,
        ]);
    }
}
