<?php

namespace App\Form;

use App\Entity\Paciente;
use App\Entity\Triagem;
use App\Repository\PacienteRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TriagemType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('altura')
            ->add('peso')
            ->add('situacao',ChoiceType::class,[
                'choices'=> array(
                    'Emergência' => 'Emergência',
                    'Muito urgênte' => 'Muito urgênte',
                    'Urgênte' => 'Urgênte',
                    'Pouco urgênte' => 'Pouco urgênte',
                    'Não urgênte' => 'Não urgênte'
                )
            ])
            ->add('paciente',EntityType::class,[
                'class'=> Paciente::class,
                'choice_label' => 'nome',
                'label' => 'Paciênte',
                'query_builder' => function(PacienteRepository $pacienteRepository){
                return $pacienteRepository->createQueryBuilder('p')
                  ->orderBy('p.nome','ASC');
        }
    ])
            ->add('situacaoDeentrada')
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Triagem::class,
        ]);
    }
}
