<?php

namespace App\Form;

use App\Entity\AreaFormacao;
use App\Entity\Pais;
use App\Entity\Usuario;
use App\Repository\AreaFormacaoRepository;
use App\Repository\PaisRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class UsuarioMedicoType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('estadoCivil',ChoiceType::class,[
                'choices'=> array(
                    'Solteiro(a)' => 'Solteiro(a)',
                    'Casado(a)' => 'Casado(a)',
                    'Divorciado(a)' => 'Divorciado(a)',
                    'Viúvo(a)' => 'Viúva(a)'
                )
            ])
            ->add('sexo',ChoiceType::class,[
                'choices'=> array(
                    'Masculino' => 'Masculino',
                    'Femenino' => 'Femenino',
                )
            ])
            ->add('numOrdem')
            ->add('nacionalidade',EntityType::class,[
                    'class'=> Pais::class,
                    'choice_label' => 'nome',
                    'label' => 'País',
                    'query_builder' => function(PaisRepository $paisRepository){
                           return $paisRepository->createQueryBuilder('p')
                    ->orderBy('p.nome','ASC');}])
            ->add('formacao',EntityType::class,[
                   'class'=> AreaFormacao::class,
                   'choice_label' => 'nome',
                   'label' => 'Formação',
                   'query_builder' => function(AreaFormacaoRepository $areaFormacaoRepository){
                          return $areaFormacaoRepository->createQueryBuilder('f')
                              ->orderBy('f.nome','ASC');}])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Usuario::class,
        ]);
    }
}
