<?php

namespace App\Repository;

use App\Entity\AssegurarPaciente;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<AssegurarPaciente>
 *
 * @method AssegurarPaciente|null find($id, $lockMode = null, $lockVersion = null)
 * @method AssegurarPaciente|null findOneBy(array $criteria, array $orderBy = null)
 * @method AssegurarPaciente[]    findAll()
 * @method AssegurarPaciente[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class AssegurarPacienteRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, AssegurarPaciente::class);
    }

    public function save(AssegurarPaciente $entity, bool $flush = false): void
    {
        $this->getEntityManager()->persist($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

    public function remove(AssegurarPaciente $entity, bool $flush = false): void
    {
        $this->getEntityManager()->remove($entity);

        if ($flush) {
            $this->getEntityManager()->flush();
        }
    }

//    /**
//     * @return AssegurarPaciente[] Returns an array of AssegurarPaciente objects
//     */
//    public function findByExampleField($value): array
//    {
//        return $this->createQueryBuilder('a')
//            ->andWhere('a.exampleField = :val')
//            ->setParameter('val', $value)
//            ->orderBy('a.id', 'ASC')
//            ->setMaxResults(10)
//            ->getQuery()
//            ->getResult()
//        ;
//    }

//    public function findOneBySomeField($value): ?AssegurarPaciente
//    {
//        return $this->createQueryBuilder('a')
//            ->andWhere('a.exampleField = :val')
//            ->setParameter('val', $value)
//            ->getQuery()
//            ->getOneOrNullResult()
//        ;
//    }
}
